jQuery(function($){

	if(esUsuarioModificacion){
		$("#btn_lanzarProceso").removeClass("inv");
	}
	
	$("#Ab03b66t00").rup_table({
		
		url: "../ab03b66t00",
		colNames: [
			"id066",
			$.rup.i18n.app.expedientes.expediente,
			"idProv066",
			"idAnyo066",
			"idExp066",
			$.rup.i18n.app.mensajes.error,
			$.rup.i18n.app.inicioExpediente.fecha
		],
		colModel: [
			{ 	name: "id066", 
			 	label: "id066",
				align: "", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "idExpediente", 
			 	label: "idExpediente",
				align: "", 
				width: 50, 
				editable: false, 
				fixed: false, 
				hidden: false, 
				resizable: true,
				formatter : function(cellval, opts, rwd, act) {
					return rwd.idProv066 + "/" + rwd.idAnyo066 + "/" + rwd.idExp066 ;
				}
			},
			{ 	name: "idProv066", 
			 	label: "idProv066",
				align: "", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "idAnyo066", 
			 	label: "idAnyo066",
				align: "", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "idExp066", 
			 	label: "idExp066",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "error066", 
			 	label: "error066",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fecha066", 
			 	label: "fecha066",
				align: "", 
				width: 50, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Ab03b66t00",
        usePlugins:[
        	"feedback",
			"toolbar",
			"formEdit",
        	"fluid",
        	"filter"
         	],
		primaryKey: "id066",
		sortname: "id066",
		sortorder: "asc",
		loadOnStartUp: true
	});
	
	$("#btn_lanzarProceso").bind("click",function(){
		var urlCarga = "/ab03bRERAWar/ab03b66t00/iniciarExpediente";
		waitDialog();
		$.rup_ajax({
			url : urlCarga,
			dataType : 'json',
			cache : false,
			type : "GET",
			contentType : 'application/json',
			async : false,
			success : function(xhr, ajaxOptions) {
				if (xhr.expproc>0) {
					
					var mensaje = $.rup.i18n.app.inicioExpediente.expProcesados +": " + xhr.expproc +
		            			  "<br>      * " + $.rup.i18n.app.inicioExpediente.expOk + ": " + xhr.expok +
		            			  "<br>      * " + $.rup.i18n.app.inicioExpediente.expErr + ": " + xhr.experror;
					
		
					$.rup_messages("msgAlert", {
						title: $.rup.i18n.app.inicioExpediente.resProceso,
						message: mensaje
					});
					
					/*var mensaje = "Expedientes procesados: " + xhr.expproc +
	  			  				"<br>      * Correctos: " + xhr.expok +
	  			  				"<br>      * Con error: " + xhr.experror;
					
					$.rup_messages("msgAlert", {
						title: "Resultado del proceso",
						message: mensaje
					});
					*/
					
				}
			},
			error : function(error){
				pintarFeedbackError(error.responseText, $("#Ab03b66t00_feedback"));
			},
			complete:function(xhr, ajaxOptions) {
				$("#Ab03b66t00").rup_table("reloadGrid", false);
				closeWaitDialog();
			}
		});
	});

});

function ocultar(capaAcordeon){
	$(capaAcordeon).toggle();
};